/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iaccess.launch;

import com.ibm.iaccess.launch.AcsClassLoaderStatusEvent;
import com.ibm.iaccess.launch.AcsClassloaderStatusListener;
import com.ibm.iaccess.launch.AcsJarFileMgr;
import com.ibm.iaccess.launch.AcsLookasideJarsMgr;
import com.ibm.iaccess.launch.AcsProperties;
import com.ibm.iaccess.launch.AcsStartupUtil;
import com.ibm.iaccess.launch.CopyrightLaunch;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.List;

@CopyrightLaunch(value="Licensed Materials - Property of IBM\n5733-XJ1\n(C) Copyright IBM Corp. 2011, 2022. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n")
public class AcsClassloader
extends URLClassLoader {
    public static final String URL_PROTOCOL_CL_RESOURCE = "acscl";
    private static AcsClassloader m_classLoader = null;
    private static boolean m_isVerboseOn = false;
    private static volatile BufferedWriter m_traceOut;
    private final List<AcsClassloaderStatusListener> m_listeners = new ArrayList<AcsClassloaderStatusListener>();
    private static final URLStreamHandler m_urlHandler;

    private void updateListeners(String string, String string2) {
        AcsClassLoaderStatusEvent acsClassLoaderStatusEvent = new AcsClassLoaderStatusEvent(string, null == string2 ? "" : string2);
        for (AcsClassloaderStatusListener acsClassloaderStatusListener : this.m_listeners) {
            acsClassloaderStatusListener.classloaderStatus(acsClassLoaderStatusEvent);
        }
    }

    private void updateListeners(String string) {
        this.updateListeners(string, null);
    }

    public void addListener(AcsClassloaderStatusListener acsClassloaderStatusListener) {
        if (null != acsClassloaderStatusListener) {
            this.m_listeners.add(acsClassloaderStatusListener);
        }
    }

    AcsClassloader(AcsLookasideJarsMgr acsLookasideJarsMgr, URL[] uRLArray, List<URL> list, ClassLoader classLoader, AcsClassloaderStatusListener acsClassloaderStatusListener) {
        super(uRLArray, classLoader);
        if (null != acsClassloaderStatusListener) {
            this.m_listeners.add(acsClassloaderStatusListener);
        }
        if (AcsLookasideJarsMgr.isUsed()) {
            try {
                acsLookasideJarsMgr.load(list);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            for (URL uRL : acsLookasideJarsMgr.getLookasideJars()) {
                super.addURL(uRL);
            }
        } else {
            if (AcsProperties.getProperties().isInMemoryJarCaching()) {
                System.out.println("Using in-memory buffer for nested jars");
            }
            for (URL uRL : list) {
                this.updateListeners(AcsStartupUtil.mri.nls("acsmsg.11"), uRL.toString());
                String string = uRL.toString().replaceAll(".*!", "");
                try {
                    URL uRL2 = new URL(URL_PROTOCOL_CL_RESOURCE, "", -1, string, m_urlHandler);
                    super.addURL(uRL2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        AcsClassloader.writeTraceData("Classloader initialized");
        this.updateListeners(AcsStartupUtil.mri.nls("acsmsg.12"));
    }

    public static AcsClassloader getClassLoader() {
        return m_classLoader;
    }

    protected static void setClassLoader(AcsClassloader acsClassloader) {
        m_classLoader = acsClassloader;
    }

    protected static boolean isVerboseOn() {
        return m_isVerboseOn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeTraceData(String string) {
        if (!AcsClassloader.isVerboseOn()) {
            return;
        }
        Class<AcsClassloader> clazz = AcsClassloader.class;
        synchronized (AcsClassloader.class) {
            if (m_traceOut == null) {
                try {
                    m_traceOut = new BufferedWriter(new OutputStreamWriter(new FileOutputStream("cltrace.txt")));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (null == m_traceOut) {
                return;
            }
            try {
                m_traceOut.write(string + "\n");
                m_traceOut.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
    }

    public void removeListener(AcsClassloaderStatusListener acsClassloaderStatusListener) {
        this.m_listeners.remove(acsClassloaderStatusListener);
    }

    public void productSeemsStarted() {
        for (AcsClassloaderStatusListener acsClassloaderStatusListener : this.m_listeners) {
            acsClassloaderStatusListener.productSeemsStarted();
        }
    }

    static {
        m_urlHandler = new ClassloaderURLHandler();
        m_isVerboseOn = System.getProperty("com.ibm.iaccess.classloader.verbose", "off").equalsIgnoreCase("on");
    }

    @CopyrightLaunch(value="Licensed Materials - Property of IBM\n5733-XJ1\n(C) Copyright IBM Corp. 2011, 2022. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n")
    public static class ClassloaderURLHandler
    extends URLStreamHandler {
        @Override
        protected URLConnection openConnection(URL uRL) throws IOException {
            return new ClassloaderURLConnection(uRL);
        }
    }

    @CopyrightLaunch(value="Licensed Materials - Property of IBM\n5733-XJ1\n(C) Copyright IBM Corp. 2011, 2022. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n")
    private static class ClassloaderURLConnection
    extends URLConnection {
        private static final String DEFAULT_MIME_TYPE = "application/octet-stream";
        private final URL m_url;

        protected ClassloaderURLConnection(URL uRL) {
            super(uRL);
            this.m_url = uRL;
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            try {
                return AcsJarFileMgr.getManager().readJarFilePlain(this.m_url.getFile());
            }
            catch (Exception exception) {
                AcsStartupUtil.addDelayedLog("Error getting data for URL: " + this.m_url);
                AcsStartupUtil.addDelayedLog(exception);
                throw exception instanceof IOException ? (IOException)exception : new IOException(exception);
            }
        }

        @Override
        public String getContentType() {
            try {
                String string = URLConnection.guessContentTypeFromStream(this.getInputStream());
                if (null != string) {
                    return string;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return DEFAULT_MIME_TYPE;
        }
    }
}

